/*
 * Decompiled with CFR 0.152.
 */
package me.cassayre.florian.masterproject.front.printer;

import java.io.Serializable;
import lisa.kernel.fol.FOL$;
import lisa.kernel.fol.FormulaDefinitions;
import lisa.kernel.fol.FormulaLabelDefinitions;
import lisa.kernel.fol.Substitutions;
import lisa.kernel.fol.TermDefinitions;
import lisa.kernel.fol.TermLabelDefinitions;
import lisa.kernel.proof.SCProof;
import lisa.kernel.proof.SCProofCheckerJudgement;
import lisa.kernel.proof.SequentCalculus;
import me.cassayre.florian.masterproject.front.fol.definitions.FormulaDefinitions;
import me.cassayre.florian.masterproject.front.package$package$;
import me.cassayre.florian.masterproject.front.parser.FrontSymbols$FrontLatexSymbols$;
import me.cassayre.florian.masterproject.front.parser.KernelRuleIdentifiers;
import me.cassayre.florian.masterproject.front.parser.KernelRuleIdentifiers$;
import me.cassayre.florian.masterproject.front.printer.FrontPositionedPrinter$;
import me.cassayre.florian.masterproject.front.printer.FrontPrintParameters;
import me.cassayre.florian.masterproject.front.printer.FrontPrintParameters$;
import me.cassayre.florian.masterproject.front.printer.FrontPrintStyle;
import me.cassayre.florian.masterproject.front.printer.FrontPrintStyle$;
import me.cassayre.florian.masterproject.front.printer.KernelPrinter;
import me.cassayre.florian.masterproject.front.printer.KernelPrinter$NormalStepWrapper$;
import me.cassayre.florian.masterproject.front.printer.KernelPrinter$ProofWrapper$;
import me.cassayre.florian.masterproject.front.printer.KernelPrinter$SubproofStepWrapper$;
import me.cassayre.florian.masterproject.front.proof.sequent.SequentDefinitions;
import me.cassayre.florian.masterproject.util.SCUtils$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class KernelPrinter$
implements Serializable {
    private static final KernelPrinter$ProofWrapper$ ProofWrapper;
    private static final KernelPrinter$NormalStepWrapper$ NormalStepWrapper;
    private static final KernelPrinter$SubproofStepWrapper$ SubproofStepWrapper;
    public static final KernelPrinter$ MODULE$;

    private KernelPrinter$() {
    }

    static {
        MODULE$ = new KernelPrinter$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KernelPrinter$.class);
    }

    private SequentDefinitions.Sequent sequentFromKernel(SequentCalculus.Sequent s) {
        return package$package$.MODULE$.Sequent().apply((IndexedSeq<FormulaDefinitions.Formula>)this.sorted$1((IndexedSeq)s.left().toIndexedSeq().map((Function1 & Serializable)formula -> package$package$.MODULE$.fromKernel(formula))), (IndexedSeq<FormulaDefinitions.Formula>)this.sorted$1((IndexedSeq)s.right().toIndexedSeq().map((Function1 & Serializable)formula -> package$package$.MODULE$.fromKernel(formula))));
    }

    public String prettyProof(SCProof scProof, FrontPrintStyle style, boolean compact, boolean explicit) {
        return this.prettyJudgedProof((SCProofCheckerJudgement)SCProofCheckerJudgement.SCValidProof$.MODULE$.apply(scProof), style, compact, explicit);
    }

    public FrontPrintStyle prettyProof$default$2() {
        return FrontPrintStyle$.Unicode;
    }

    public boolean prettyProof$default$3() {
        return false;
    }

    public boolean prettyProof$default$4() {
        return false;
    }

    public String prettyJudgedProof(SCProofCheckerJudgement judgement, FrontPrintStyle style, boolean compact, boolean explicit) {
        Seq seq;
        SCProof scProof = judgement.proof();
        FrontPrintParameters p = FrontPrintParameters$.MODULE$.apply(style, compact);
        KernelRuleIdentifiers r = KernelRuleIdentifiers$.MODULE$.apply(p.s());
        String placeholder = "_";
        KernelPrinter.ProofWrapper proof = this.wrap$1(style, compact, explicit, r, placeholder, scProof);
        FrontPrintStyle frontPrintStyle = style;
        FrontPrintStyle frontPrintStyle2 = FrontPrintStyle$.Latex;
        FrontPrintStyle frontPrintStyle3 = frontPrintStyle;
        String columnInterleaving = !(frontPrintStyle2 != null ? !frontPrintStyle2.equals(frontPrintStyle3) : frontPrintStyle3 != null) ? " & " : " ";
        Map numberColumnEnds = this.computeNumberColumnEnds$1(columnInterleaving, proof, 0, (Seq)package$.MODULE$.Seq().empty());
        int maximumNumberColumnEnd = BoxesRunTime.unboxToInt((Object)numberColumnEnds.values().max((Ordering)Ordering.Int$.MODULE$));
        int maximumNumberColumnDepth = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)numberColumnEnds.keys().map((Function1 & Serializable)_$7 -> _$7.size())).max((Ordering)Ordering.Int$.MODULE$));
        int maximumRuleNameLength = this.computeMaximumRuleNameLength$1(style, proof);
        String proofStepIndicator = new StringBuilder(1).append(p.s().Implies()).append(" ").toString();
        String proofStepNoIndicator = StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), proofStepIndicator.length());
        FrontPrintStyle frontPrintStyle4 = style;
        FrontPrintStyle frontPrintStyle5 = FrontPrintStyle$.Latex;
        FrontPrintStyle frontPrintStyle6 = frontPrintStyle4;
        String lineSeparator = !(frontPrintStyle5 != null ? !frontPrintStyle5.equals(frontPrintStyle6) : frontPrintStyle6 != null) ? " \\\\\n" : "\n";
        SCProofCheckerJudgement sCProofCheckerJudgement = judgement;
        if (sCProofCheckerJudgement instanceof SCProofCheckerJudgement.SCValidProof) {
            SCProofCheckerJudgement.SCValidProof sCValidProof = SCProofCheckerJudgement.SCValidProof$.MODULE$.unapply((SCProofCheckerJudgement.SCValidProof)sCProofCheckerJudgement);
            SCProof sCProof = sCValidProof._1();
            seq = (Seq)package$.MODULE$.Seq().empty();
        } else if (sCProofCheckerJudgement instanceof SCProofCheckerJudgement.SCInvalidProof) {
            SCProofCheckerJudgement.SCInvalidProof sCInvalidProof = SCProofCheckerJudgement.SCInvalidProof$.MODULE$.unapply((SCProofCheckerJudgement.SCInvalidProof)sCProofCheckerJudgement);
            SCProof sCProof = sCInvalidProof._1();
            Seq seq2 = sCInvalidProof._2();
            String string = sCInvalidProof._3();
            Seq path = seq2;
            String message = string;
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(46).append("Proof checker has reported an error at line ").append(path.mkString(".")).append(": ").append(message).toString()}));
        } else {
            throw new MatchError((Object)sCProofCheckerJudgement);
        }
        Seq errorSeq = seq;
        Seq allLinesPairs = this.recursivePrint$1(judgement, style, compact, p, columnInterleaving, numberColumnEnds, maximumNumberColumnEnd, maximumNumberColumnDepth, maximumRuleNameLength, proofStepIndicator, proofStepNoIndicator, proof, (Seq)package$.MODULE$.Seq().empty());
        int maximumLengthFirst = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)allLinesPairs.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String first = (String)tuple2._1();
                return first.length();
            }
            throw new MatchError((Object)tuple2);
        })).max((Ordering)Ordering.Int$.MODULE$));
        Seq contentProof = (Seq)allLinesPairs.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String first = (String)tuple2._1();
                String second = (String)tuple2._2();
                return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{first, StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maximumLengthFirst - first.length()), explicit ? columnInterleaving : "", second})).mkString().replaceAll("\\s+$", "");
            }
            throw new MatchError((Object)tuple2);
        });
        String content = ((IterableOnceOps)contentProof.$plus$plus((IterableOnce)errorSeq)).mkString(lineSeparator);
        FrontPrintStyle frontPrintStyle7 = style;
        FrontPrintStyle frontPrintStyle8 = FrontPrintStyle$.Latex;
        FrontPrintStyle frontPrintStyle9 = frontPrintStyle7;
        if (!(frontPrintStyle8 != null ? !frontPrintStyle8.equals(frontPrintStyle9) : frontPrintStyle9 != null)) {
            return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"\\tiny", new StringBuilder(18).append("$\\begin{array}{").append(RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), maximumNumberColumnDepth).map((Function1 & Serializable)i -> this.prettyJudgedProof$$anonfun$1(maximumNumberColumnDepth, BoxesRunTime.unboxToInt((Object)i))).mkString()).append("ll").append(explicit ? "l" : "").append("}").toString(), content, "\\end{array}$", "\\normalsize"})).mkString("\n");
        }
        return content;
    }

    public FrontPrintStyle prettyJudgedProof$default$2() {
        return FrontPrintStyle$.Unicode;
    }

    public boolean prettyJudgedProof$default$3() {
        return false;
    }

    public boolean prettyJudgedProof$default$4() {
        return false;
    }

    public String prettyProofTreeLatex(SCProof scProof) {
        KernelRuleIdentifiers r = KernelRuleIdentifiers$.MODULE$.apply(FrontSymbols$FrontLatexSymbols$.MODULE$);
        SCProof flatProof = SCUtils$.MODULE$.flattenProof(scProof);
        Seq orderedSteps = this.postOrder$1(flatProof, (SequentCalculus.SCProofStep)flatProof.steps().last());
        Seq orderedStepsOptionals = (Seq)orderedSteps.flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                SequentCalculus.SCProofStep step = (SequentCalculus.SCProofStep)((Left)either).value();
                return (Seq)(step.premises().isEmpty() ? (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{package$.MODULE$.Right().apply((Object)None$.MODULE$)})) : (Seq)package$.MODULE$.Seq().empty()).$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Left[]{package$.MODULE$.Left().apply((Object)step)})));
            }
            if (either instanceof Right) {
                SequentCalculus.Sequent sequent = (SequentCalculus.Sequent)((Right)either).value();
                return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)sequent))}));
            }
            throw new MatchError((Object)either);
        });
        String string = "\\begin{prooftree}";
        return ((IterableOnceOps)((SeqOps)((SeqOps)orderedStepsOptionals.map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                SequentCalculus.SCProofStep step = (SequentCalculus.SCProofStep)((Left)either).value();
                return new StringBuilder(12).append("\\infer").append(Math.max(step.premises().size(), 1)).append("[$").append(r.identify(step)).append("$]{").append(this.prettySequent$1(step.bot())).append("}").toString();
            }
            if (either instanceof Right) {
                Option option = (Option)((Right)either).value();
                if (None$.MODULE$.equals(option)) {
                    return "\\hypo{}";
                }
                if (option instanceof Some) {
                    SequentCalculus.Sequent sequent = (SequentCalculus.Sequent)((Some)option).value();
                    return new StringBuilder(7).append("\\hypo{").append(this.prettySequent$1(sequent)).append("}").toString();
                }
            }
            throw new MatchError((Object)either);
        })).$plus$colon((Object)string)).$colon$plus((Object)"\\end{prooftree}")).mkString("\n");
    }

    private final IndexedSeq sorted$1(IndexedSeq seq) {
        return (IndexedSeq)seq.sortBy((Function1 & Serializable)_$1 -> _$1.toString(), (Ordering)Ordering.String$.MODULE$);
    }

    private final String prettyName$1(FrontPrintStyle style$1, String name) {
        FrontPrintStyle frontPrintStyle = style$1;
        FrontPrintStyle frontPrintStyle2 = FrontPrintStyle$.Latex;
        FrontPrintStyle frontPrintStyle3 = frontPrintStyle;
        if (!(frontPrintStyle2 != null ? !frontPrintStyle2.equals(frontPrintStyle3) : frontPrintStyle3 != null)) {
            return new StringBuilder(7).append("\\text{").append(name).append("}").toString();
        }
        return name;
    }

    private final String prettyParameters$1(boolean compact$1, FrontPrintParameters p$1, Seq parameters) {
        if (parameters.isEmpty()) {
            return "";
        }
        return new StringBuilder(0).append(p$1.s().SquareBracketOpen()).append(parameters.mkString(new StringBuilder(0).append(p$1.s().Semicolon()).append(compact$1 ? "" : " ").toString())).append(p$1.s().SquareBracketClose()).toString();
    }

    private final String prettyFormula$1(FrontPrintStyle style$2, boolean compact$2, FormulaDefinitions.Formula f) {
        return FrontPositionedPrinter$.MODULE$.prettyFormula(package$package$.MODULE$.fromKernel(f), style$2, compact$2);
    }

    private final String prettyTerm$1(FrontPrintStyle style$3, boolean compact$3, TermDefinitions.Term t) {
        return FrontPositionedPrinter$.MODULE$.prettyTerm(package$package$.MODULE$.fromKernel(t), style$3, compact$3, FrontPositionedPrinter$.MODULE$.prettyTerm$default$4());
    }

    private final String prettyFunction$1(FrontPrintStyle style$12, boolean compact$10, TermLabelDefinitions.FunctionLabel label, Substitutions.LambdaTermTerm lambda) {
        return this.prettyFormula$1(style$12, compact$10, (FormulaDefinitions.Formula)FOL$.MODULE$.PredicateFormula().apply((FormulaLabelDefinitions.PredicateLabel)FOL$.MODULE$.equality(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TermDefinitions.Term[]{FOL$.MODULE$.FunctionTerm().apply(label, (Seq)lambda.vars().map((Function1 & Serializable)_$2 -> FOL$.MODULE$.FunctionTerm().apply((TermLabelDefinitions.FunctionLabel)_$2, (Seq)package$.MODULE$.Seq().empty()))), lambda.body()}))));
    }

    private final String prettyPredicate$1(FrontPrintStyle style$13, boolean compact$11, FormulaLabelDefinitions.PredicateLabel label, Substitutions.LambdaTermFormula lambda) {
        return this.prettyFormula$1(style$13, compact$11, (FormulaDefinitions.Formula)FOL$.MODULE$.ConnectorFormula().apply((FormulaLabelDefinitions.ConnectorLabel)FOL$.MODULE$.Iff(), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{FOL$.MODULE$.PredicateFormula().apply(label, (Seq)lambda.vars().map((Function1 & Serializable)_$3 -> FOL$.MODULE$.FunctionTerm().apply((TermLabelDefinitions.FunctionLabel)_$3, (Seq)package$.MODULE$.Seq().empty()))), lambda.body()}))));
    }

    private final KernelPrinter.ProofWrapper wrap$1(FrontPrintStyle style$4, boolean compact$4, boolean explicit$1, KernelRuleIdentifiers r$1, String placeholder$1, SCProof scProof) {
        IndexedSeq steps = (IndexedSeq)scProof.steps().map((Function1 & Serializable)step -> {
            KernelPrinter.StepWrapper stepWrapper;
            Seq seq;
            String name = r$1.identify((SequentCalculus.SCProofStep)step);
            SequentCalculus.SCProofStep sCProofStep = step;
            if (sCProofStep instanceof SequentCalculus.Hypothesis) {
                SequentCalculus.Hypothesis s = (SequentCalculus.Hypothesis)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi())}));
            } else if (sCProofStep instanceof SequentCalculus.Cut) {
                SequentCalculus.Cut s = (SequentCalculus.Cut)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi())}));
            } else if (sCProofStep instanceof SequentCalculus.Rewrite) {
                seq = (Seq)package$.MODULE$.Seq().empty();
            } else if (sCProofStep instanceof SequentCalculus.Weakening) {
                seq = (Seq)package$.MODULE$.Seq().empty();
            } else if (sCProofStep instanceof SequentCalculus.LeftAnd) {
                SequentCalculus.LeftAnd s = (SequentCalculus.LeftAnd)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{s.phi(), s.psi()})).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.RightAnd) {
                SequentCalculus.RightAnd s = (SequentCalculus.RightAnd)sCProofStep;
                seq = (Seq)s.cunjuncts().map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.LeftOr) {
                SequentCalculus.LeftOr s = (SequentCalculus.LeftOr)sCProofStep;
                seq = (Seq)s.disjuncts().map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.RightOr) {
                SequentCalculus.RightOr s = (SequentCalculus.RightOr)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{s.phi(), s.psi()})).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.LeftImplies) {
                SequentCalculus.LeftImplies s = (SequentCalculus.LeftImplies)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{s.phi(), s.psi()})).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.RightImplies) {
                SequentCalculus.RightImplies s = (SequentCalculus.RightImplies)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{s.phi(), s.psi()})).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.LeftIff) {
                SequentCalculus.LeftIff s = (SequentCalculus.LeftIff)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{s.phi(), s.psi()})).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.RightIff) {
                SequentCalculus.RightIff s = (SequentCalculus.RightIff)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{s.phi(), s.psi()})).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f));
            } else if (sCProofStep instanceof SequentCalculus.LeftNot) {
                SequentCalculus.LeftNot s = (SequentCalculus.LeftNot)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi())}));
            } else if (sCProofStep instanceof SequentCalculus.RightNot) {
                SequentCalculus.RightNot s = (SequentCalculus.RightNot)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi())}));
            } else if (sCProofStep instanceof SequentCalculus.LeftForall) {
                SequentCalculus.LeftForall s = (SequentCalculus.LeftForall)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi()), s.x().id(), this.prettyTerm$1(style$4, compact$4, s.t())}));
            } else if (sCProofStep instanceof SequentCalculus.RightForall) {
                SequentCalculus.RightForall s = (SequentCalculus.RightForall)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi()), s.x().id()}));
            } else if (sCProofStep instanceof SequentCalculus.LeftExists) {
                SequentCalculus.LeftExists s = (SequentCalculus.LeftExists)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi()), s.x().id()}));
            } else if (sCProofStep instanceof SequentCalculus.RightExists) {
                SequentCalculus.RightExists s = (SequentCalculus.RightExists)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi()), s.x().id(), this.prettyTerm$1(style$4, compact$4, s.t())}));
            } else if (sCProofStep instanceof SequentCalculus.LeftExistsOne) {
                SequentCalculus.LeftExistsOne s = (SequentCalculus.LeftExistsOne)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi()), s.x().id()}));
            } else if (sCProofStep instanceof SequentCalculus.RightExistsOne) {
                SequentCalculus.RightExistsOne s = (SequentCalculus.RightExistsOne)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.phi()), s.x().id()}));
            } else if (sCProofStep instanceof SequentCalculus.LeftRefl) {
                SequentCalculus.LeftRefl s = (SequentCalculus.LeftRefl)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.fa())}));
            } else if (sCProofStep instanceof SequentCalculus.RightRefl) {
                SequentCalculus.RightRefl s = (SequentCalculus.RightRefl)sCProofStep;
                seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.prettyFormula$1(style$4, compact$4, s.fa())}));
            } else if (sCProofStep instanceof SequentCalculus.LeftSubstEq) {
                SequentCalculus.LeftSubstEq s = (SequentCalculus.LeftSubstEq)sCProofStep;
                seq = (Seq)s.equals().flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TermDefinitions.Term l = (TermDefinitions.Term)tuple2._1();
                        TermDefinitions.Term r = (TermDefinitions.Term)tuple2._2();
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TermDefinitions.Term[]{l, r}));
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)t -> this.prettyTerm$1(style$4, compact$4, (TermDefinitions.Term)t)).$colon$plus((Object)this.prettyPredicate$1(style$4, compact$4, (FormulaLabelDefinitions.PredicateLabel)FOL$.MODULE$.ConstantPredicateLabel().apply(placeholder$1, s.lambdaPhi().vars().size()), s.lambdaPhi()));
            } else if (sCProofStep instanceof SequentCalculus.RightSubstEq) {
                SequentCalculus.RightSubstEq s = (SequentCalculus.RightSubstEq)sCProofStep;
                seq = (Seq)s.equals().flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TermDefinitions.Term l = (TermDefinitions.Term)tuple2._1();
                        TermDefinitions.Term r = (TermDefinitions.Term)tuple2._2();
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TermDefinitions.Term[]{l, r}));
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)t -> this.prettyTerm$1(style$4, compact$4, (TermDefinitions.Term)t)).$colon$plus((Object)this.prettyPredicate$1(style$4, compact$4, (FormulaLabelDefinitions.PredicateLabel)FOL$.MODULE$.ConstantPredicateLabel().apply(placeholder$1, s.lambdaPhi().vars().size()), s.lambdaPhi()));
            } else if (sCProofStep instanceof SequentCalculus.LeftSubstIff) {
                SequentCalculus.LeftSubstIff s = (SequentCalculus.LeftSubstIff)sCProofStep;
                seq = (Seq)s.equals().flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        FormulaDefinitions.Formula l = (FormulaDefinitions.Formula)tuple2._1();
                        FormulaDefinitions.Formula r = (FormulaDefinitions.Formula)tuple2._2();
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{l, r}));
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f)).$colon$plus((Object)this.prettyPredicate$1(style$4, compact$4, (FormulaLabelDefinitions.PredicateLabel)FOL$.MODULE$.ConstantPredicateLabel().apply(placeholder$1, s.lambdaPhi().vars().size()), FOL$.MODULE$.LambdaTermFormula().apply((Seq)s.lambdaPhi().vars().map((Function1 & Serializable)v -> FOL$.MODULE$.SchematicFunctionLabel().apply(v.id(), v.arity())), s.lambdaPhi().body())));
            } else if (sCProofStep instanceof SequentCalculus.RightSubstIff) {
                SequentCalculus.RightSubstIff s = (SequentCalculus.RightSubstIff)sCProofStep;
                seq = (Seq)s.equals().flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        FormulaDefinitions.Formula l = (FormulaDefinitions.Formula)tuple2._1();
                        FormulaDefinitions.Formula r = (FormulaDefinitions.Formula)tuple2._2();
                        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new FormulaDefinitions.Formula[]{l, r}));
                    }
                    throw new MatchError((Object)tuple2);
                }).map((Function1 & Serializable)f -> this.prettyFormula$1(style$4, compact$4, (FormulaDefinitions.Formula)f)).$colon$plus((Object)this.prettyPredicate$1(style$4, compact$4, (FormulaLabelDefinitions.PredicateLabel)FOL$.MODULE$.ConstantPredicateLabel().apply(placeholder$1, s.lambdaPhi().vars().size()), FOL$.MODULE$.LambdaTermFormula().apply((Seq)s.lambdaPhi().vars().map((Function1 & Serializable)v -> FOL$.MODULE$.SchematicFunctionLabel().apply(v.id(), v.arity())), s.lambdaPhi().body())));
            } else if (sCProofStep instanceof SequentCalculus.InstFunSchema) {
                SequentCalculus.InstFunSchema s = (SequentCalculus.InstFunSchema)sCProofStep;
                seq = (Seq)s.insts().toSeq().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TermLabelDefinitions.SchematicFunctionLabel label = (TermLabelDefinitions.SchematicFunctionLabel)tuple2._1();
                        Substitutions.LambdaTermTerm lambda = (Substitutions.LambdaTermTerm)tuple2._2();
                        return this.prettyFunction$1(style$4, compact$4, (TermLabelDefinitions.FunctionLabel)label, lambda);
                    }
                    throw new MatchError((Object)tuple2);
                });
            } else if (sCProofStep instanceof SequentCalculus.InstPredSchema) {
                SequentCalculus.InstPredSchema s = (SequentCalculus.InstPredSchema)sCProofStep;
                seq = (Seq)s.insts().toSeq().map((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        FormulaLabelDefinitions.SchematicPredicateLabel label = (FormulaLabelDefinitions.SchematicPredicateLabel)tuple2._1();
                        Substitutions.LambdaTermFormula lambda = (Substitutions.LambdaTermFormula)tuple2._2();
                        return this.prettyPredicate$1(style$4, compact$4, (FormulaLabelDefinitions.PredicateLabel)label, lambda);
                    }
                    throw new MatchError((Object)tuple2);
                });
            } else {
                if (!(sCProofStep instanceof SequentCalculus.SCSubproof)) throw new MatchError((Object)sCProofStep);
                SequentCalculus.SCSubproof sCSubproof = SequentCalculus.SCSubproof$.MODULE$.unapply((SequentCalculus.SCSubproof)sCProofStep);
                SCProof sCProof = sCSubproof._1();
                Seq seq2 = sCSubproof._2();
                boolean bl = sCSubproof._3();
                if (bl) {
                    seq = (Seq)package$.MODULE$.Seq().empty();
                } else {
                    if (false != bl) throw new MatchError((Object)sCProofStep);
                    seq = (Seq)package$.MODULE$.Seq().empty();
                }
            }
            Seq parameters = seq;
            SequentCalculus.SCProofStep sCProofStep2 = step;
            if (sCProofStep2 instanceof SequentCalculus.SCSubproof) {
                SequentCalculus.SCSubproof sCSubproof = SequentCalculus.SCSubproof$.MODULE$.unapply((SequentCalculus.SCSubproof)sCProofStep2);
                SCProof sCProof = sCSubproof._1();
                Seq seq3 = sCSubproof._2();
                boolean bl = sCSubproof._3();
                SCProof sp2 = sCProof;
                Seq premises = seq3;
                if (bl) {
                    stepWrapper = KernelPrinter$SubproofStepWrapper$.MODULE$.apply(name, this.wrap$1(style$4, compact$4, explicit$1, r$1, placeholder$1, sp2), (Seq<Object>)premises);
                    return stepWrapper;
                }
            }
            stepWrapper = KernelPrinter$NormalStepWrapper$.MODULE$.apply(name, (Seq<Object>)step.premises(), this.sequentFromKernel(step.bot()), (Seq<String>)(explicit$1 ? parameters : (Seq)package$.MODULE$.Seq().empty()));
            return stepWrapper;
        });
        return KernelPrinter$ProofWrapper$.MODULE$.apply((IndexedSeq<KernelPrinter.StepWrapper>)steps, (IndexedSeq<SequentDefinitions.Sequent>)((IndexedSeq)scProof.imports().map((Function1 & Serializable)s -> this.sequentFromKernel((SequentCalculus.Sequent)s))));
    }

    private final /* synthetic */ Object prettyStepName$1$$anonfun$1(FrontPrintStyle style$7, int i) {
        FrontPrintStyle frontPrintStyle = style$7;
        FrontPrintStyle frontPrintStyle2 = FrontPrintStyle$.Latex;
        if (!(frontPrintStyle != null ? !frontPrintStyle.equals(frontPrintStyle2) : frontPrintStyle2 != null) && i < 0) {
            return new StringBuilder(2).append("{").append(i).append("}").toString();
        }
        return BoxesRunTime.boxToInteger((int)i);
    }

    private final String prettyStepName$1(FrontPrintStyle style$6, KernelPrinter.StepWrapper step) {
        Object[] objectArray = new String[3];
        objectArray[0] = step.name();
        FrontPrintStyle frontPrintStyle = style$6;
        FrontPrintStyle frontPrintStyle2 = FrontPrintStyle$.Latex;
        objectArray[1] = !(frontPrintStyle != null ? !frontPrintStyle.equals(frontPrintStyle2) : frontPrintStyle2 != null) ? "~" : " ";
        objectArray[2] = ((IterableOnceOps)step.premises().map((Function1 & Serializable)i -> this.prettyStepName$1$$anonfun$1(style$6, BoxesRunTime.unboxToInt((Object)i)))).mkString(", ");
        return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)).mkString();
    }

    private final Map computeNumberColumnEnds$1(String columnInterleaving$1, KernelPrinter.ProofWrapper proof, int nextColumnStart, Seq path) {
        int maxCharCount = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-proof.imports().size(), proof.steps().size() - 1})).map((Function1)(JFunction1.mcII.sp & Serializable)_$4 -> BoxesRunTime.boxToInteger((int)_$4).toString().length())).max((Ordering)Ordering.Int$.MODULE$));
        int columnEnd = nextColumnStart + maxCharCount - 1;
        int newNextColumnStart = columnEnd + 1 + columnInterleaving$1.length();
        Seq seq = (Seq)Predef$.MODULE$.ArrowAssoc((Object)path);
        return (Map)((MapOps)((IterableOnceOps)((IndexedSeqOps)proof.steps().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            KernelPrinter.StepWrapper stepWrapper;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null && (stepWrapper = (KernelPrinter.StepWrapper)tuple2._1()) instanceof KernelPrinter.SubproofStepWrapper) {
                KernelPrinter.SubproofStepWrapper subproofStepWrapper = KernelPrinter$SubproofStepWrapper$.MODULE$.unapply((KernelPrinter.SubproofStepWrapper)stepWrapper);
                String string = subproofStepWrapper._1();
                KernelPrinter.ProofWrapper proofWrapper = subproofStepWrapper._2();
                Seq<Object> seq = subproofStepWrapper._3();
                KernelPrinter.ProofWrapper subProof = proofWrapper;
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return this.computeNumberColumnEnds$1(columnInterleaving$1, subProof, newNextColumnStart, (Seq)path.$plus$colon((Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return Predef$.MODULE$.Map().empty();
        })).fold((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable)(_$5, _$6) -> (Map)_$5.$plus$plus((IterableOnce)_$6))).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)seq, (Object)BoxesRunTime.boxToInteger((int)columnEnd)));
    }

    private final int computeMaximumRuleNameLength$1(FrontPrintStyle style$29, KernelPrinter.ProofWrapper proof) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)proof.steps().map((Function1 & Serializable)x$1 -> {
            KernelPrinter.StepWrapper stepWrapper = x$1;
            if (stepWrapper instanceof KernelPrinter.SubproofStepWrapper) {
                KernelPrinter.SubproofStepWrapper subproofStepWrapper = (KernelPrinter.SubproofStepWrapper)stepWrapper;
                KernelPrinter.SubproofStepWrapper subproofStepWrapper2 = KernelPrinter$SubproofStepWrapper$.MODULE$.unapply(subproofStepWrapper);
                String string = subproofStepWrapper2._1();
                KernelPrinter.ProofWrapper proofWrapper = subproofStepWrapper2._2();
                Seq<Object> seq = subproofStepWrapper2._3();
                KernelPrinter.ProofWrapper proof = proofWrapper;
                KernelPrinter.SubproofStepWrapper step = subproofStepWrapper;
                return Math.max(this.prettyStepName$1(style$29, step).length(), this.computeMaximumRuleNameLength$1(style$29, proof));
            }
            KernelPrinter.StepWrapper other = stepWrapper;
            return this.prettyStepName$1(style$29, other).length();
        })).max((Ordering)Ordering.Int$.MODULE$));
    }

    private final String prettyLine$1(SCProofCheckerJudgement judgement$2, FrontPrintStyle style$9, boolean compact$7, String columnInterleaving$4, Map numberColumnEnds$2, int maximumNumberColumnEnd$2, int maximumNumberColumnDepth$2, int maximumRuleNameLength$2, String proofStepIndicator$2, String proofStepNoIndicator$2, Seq path$2, int i, KernelPrinter.StepWrapper step) {
        String string;
        String numberColumn = BoxesRunTime.boxToInteger((int)i).toString();
        int numberColumnEnd = BoxesRunTime.unboxToInt((Object)numberColumnEnds$2.apply((Object)path$2));
        String nameWithPremises = this.prettyStepName$1(style$9, step);
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(numberColumnEnd - numberColumn.length() + 1)), (Object)BoxesRunTime.boxToInteger((int)(maximumNumberColumnEnd$2 - numberColumnEnd)));
        int leftLength = tuple2._1$mcI$sp();
        int rightLength = tuple2._2$mcI$sp();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(columnInterleaving$4), path$2.size()), (Object)StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(columnInterleaving$4), maximumNumberColumnDepth$2 - path$2.size()));
        String leftSpace = (String)tuple22._1();
        String rightSpace = (String)tuple22._2();
        Seq fullPath = (Seq)path$2.$plus$colon((Object)BoxesRunTime.boxToInteger((int)i));
        SCProofCheckerJudgement sCProofCheckerJudgement = judgement$2;
        if (sCProofCheckerJudgement instanceof SCProofCheckerJudgement.SCValidProof) {
            SCProofCheckerJudgement.SCValidProof sCValidProof = SCProofCheckerJudgement.SCValidProof$.MODULE$.unapply((SCProofCheckerJudgement.SCValidProof)sCProofCheckerJudgement);
            SCProof sCProof = sCValidProof._1();
            string = "";
        } else if (sCProofCheckerJudgement instanceof SCProofCheckerJudgement.SCInvalidProof) {
            SCProofCheckerJudgement.SCInvalidProof sCInvalidProof = SCProofCheckerJudgement.SCInvalidProof$.MODULE$.unapply((SCProofCheckerJudgement.SCInvalidProof)sCProofCheckerJudgement);
            SCProof sCProof = sCInvalidProof._1();
            Seq seq = sCInvalidProof._2();
            String string2 = sCInvalidProof._3();
            Seq errorPath = seq;
            Object object = errorPath.reverse();
            Seq seq2 = fullPath;
            string = !(object != null ? !object.equals(seq2) : seq2 != null) ? proofStepIndicator$2 : proofStepNoIndicator$2;
        } else {
            throw new MatchError((Object)sCProofCheckerJudgement);
        }
        String prefix = string;
        return new StringBuilder(0).append(prefix).append(leftSpace).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), leftLength - leftSpace.length())).append(numberColumn).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), rightLength - rightSpace.length())).append(rightSpace).append(columnInterleaving$4).append(nameWithPremises).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(" "), maximumRuleNameLength$2 - nameWithPremises.length())).append(columnInterleaving$4).append(FrontPositionedPrinter$.MODULE$.prettySequent(step.sequent(), style$9, compact$7, FrontPositionedPrinter$.MODULE$.prettySequent$default$4())).toString();
    }

    private final Seq recursivePrint$1(SCProofCheckerJudgement judgement$1, FrontPrintStyle style$8, boolean compact$6, FrontPrintParameters p$2, String columnInterleaving$3, Map numberColumnEnds$1, int maximumNumberColumnEnd$1, int maximumNumberColumnDepth$1, int maximumRuleNameLength$1, String proofStepIndicator$1, String proofStepNoIndicator$1, KernelPrinter.ProofWrapper proof, Seq path) {
        IndexedSeq importsPairs = (IndexedSeq)((IndexedSeqOps)((IndexedSeqOps)proof.imports().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SequentDefinitions.Sequent s = (SequentDefinitions.Sequent)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(-(i + 1))), (Object)KernelPrinter$NormalStepWrapper$.MODULE$.apply(this.prettyName$1(style$8, "Import"), (Seq<Object>)((Seq)package$.MODULE$.Seq().empty()), s, (Seq<String>)((Seq)package$.MODULE$.Seq().empty())));
            }
            throw new MatchError((Object)tuple2);
        })).reverse();
        IndexedSeq stepsTriplets = (IndexedSeq)((IndexedSeqOps)proof.steps().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                None$ none$;
                KernelPrinter.StepWrapper step = (KernelPrinter.StepWrapper)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                KernelPrinter.StepWrapper stepWrapper = step;
                if (stepWrapper instanceof KernelPrinter.SubproofStepWrapper) {
                    KernelPrinter.SubproofStepWrapper subproofStepWrapper = KernelPrinter$SubproofStepWrapper$.MODULE$.unapply((KernelPrinter.SubproofStepWrapper)stepWrapper);
                    String string = subproofStepWrapper._1();
                    KernelPrinter.ProofWrapper proofWrapper = subproofStepWrapper._2();
                    Seq<Object> seq = subproofStepWrapper._3();
                    KernelPrinter.ProofWrapper proof = proofWrapper;
                    none$ = Some$.MODULE$.apply((Object)proof);
                } else {
                    none$ = None$.MODULE$;
                }
                None$ option = none$;
                return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)i), (Object)step), (Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        return (Seq)((IterableOps)((IndexedSeqOps)importsPairs.map((Function1 & Serializable)x$1 -> {
            int n = BoxesRunTime.unboxToInt((Object)x$1._1());
            KernelPrinter.StepWrapper stepWrapper = (KernelPrinter.StepWrapper)x$1._2();
            return this.prettyLine$1(judgement$1, style$8, compact$6, columnInterleaving$3, numberColumnEnds$1, maximumNumberColumnEnd$1, maximumNumberColumnDepth$1, maximumRuleNameLength$1, proofStepIndicator$1, proofStepNoIndicator$1, path, n, stepWrapper);
        })).map((Function1 & Serializable)_$8 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(_$8);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"");
        })).$plus$plus((IterableOnce)stepsTriplets.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                int i = BoxesRunTime.unboxToInt((Object)tuple2._1());
                KernelPrinter.StepWrapper step = (KernelPrinter.StepWrapper)tuple2._2();
                Option option = (Option)tuple22._2();
                Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)this.prettyLine$1(judgement$1, style$8, compact$6, columnInterleaving$3, numberColumnEnds$1, maximumNumberColumnEnd$1, maximumNumberColumnDepth$1, maximumRuleNameLength$1, proofStepIndicator$1, proofStepNoIndicator$1, path, i, step), (Object)this.prettyParameters$1(compact$6, p$2, step.parameters()));
                return (Seq)((SeqOps)Option$.MODULE$.option2Iterable(option).toSeq().flatMap((Function1 & Serializable)proof -> this.recursivePrint$1(judgement$1, style$8, compact$6, p$2, columnInterleaving$3, numberColumnEnds$1, maximumNumberColumnEnd$1, maximumNumberColumnDepth$1, maximumRuleNameLength$1, proofStepIndicator$1, proofStepNoIndicator$1, (KernelPrinter.ProofWrapper)proof, (Seq)path.$plus$colon((Object)BoxesRunTime.boxToInteger((int)i))))).$plus$colon((Object)tuple23);
            }
            throw new MatchError((Object)tuple22);
        }));
    }

    private final /* synthetic */ String prettyJudgedProof$$anonfun$1(int maximumNumberColumnDepth$5, int i) {
        return new StringBuilder(1).append("r").append(i < maximumNumberColumnDepth$5 ? "@{\\hskip 0.1cm}" : "").toString();
    }

    private final /* synthetic */ IterableOnce postOrder$1$$anonfun$1(SCProof flatProof$2, int i) {
        if (i >= 0) {
            return this.postOrder$1(flatProof$2, (SequentCalculus.SCProofStep)flatProof$2.steps().apply(i));
        }
        return package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Right[]{package$.MODULE$.Right().apply(flatProof$2.imports().apply(-(i + 1)))}));
    }

    private final Seq postOrder$1(SCProof flatProof$1, SequentCalculus.SCProofStep step) {
        return (Seq)((SeqOps)step.premises().flatMap((Function1 & Serializable)i -> this.postOrder$1$$anonfun$1(flatProof$1, BoxesRunTime.unboxToInt((Object)i)))).$colon$plus((Object)package$.MODULE$.Left().apply((Object)step));
    }

    private final String prettySequent$1(SequentCalculus.Sequent sequent) {
        return FrontPositionedPrinter$.MODULE$.prettySequent(this.sequentFromKernel(sequent), FrontPrintStyle$.Latex, FrontPositionedPrinter$.MODULE$.prettySequent$default$3(), FrontPositionedPrinter$.MODULE$.prettySequent$default$4());
    }
}

